/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara;

import com.sun.enterprise.web.ara.IsolatedTask;
import com.sun.enterprise.web.ara.IsolationRulesExecutor;
import com.sun.enterprise.web.ara.RulesExecutor;
import com.sun.enterprise.web.ara.algorithms.ContextRootAlgorithm;
import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import java.util.concurrent.ConcurrentLinkedQueue;

public class IsolationPipeline
extends LinkedListPipeline
implements TaskListener {
    private static final String ALGORITHM_CLASS = "com.sun.enterprise.web.ara.isolationPipeline.algorithm";
    private static final String RULE_EXECUTOR_CLASS = "com.sun.enterprise.web.ara.isolationPipeline.ruleExecutor";
    private ConcurrentLinkedQueue<IsolatedTask> isolatedTasks;

    public void initPipeline() {
        super.initPipeline();
        this.isolatedTasks = new ConcurrentLinkedQueue();
        for (int i = 0; i < this.maxThreads; ++i) {
            this.isolatedTasks.offer(this.newIsolatedTask());
        }
    }

    public void addTask(Task task) {
        if (task.getType() == 1) {
            super.addTask(this.wrap(task));
        } else {
            super.addTask(task);
        }
    }

    private Task wrap(Task task) {
        IsolatedTask isolatedTask = this.isolatedTasks.poll();
        if (isolatedTask == null) {
            isolatedTask = this.newIsolatedTask();
        }
        isolatedTask.wrap(task);
        return isolatedTask;
    }

    private IsolatedTask newIsolatedTask() {
        IsolatedTask task = new IsolatedTask();
        task.setAlgorithm(this.newAlgorithm());
        task.setRulesExecutor(this.newRulesExecutor());
        task.addTaskListener(this);
        task.pipeline = this;
        return task;
    }

    private StreamAlgorithm newAlgorithm() {
        return (StreamAlgorithm)this.loadInstance(ALGORITHM_CLASS);
    }

    private RulesExecutor newRulesExecutor() {
        return (IsolationRulesExecutor)this.loadInstance(RULE_EXECUTOR_CLASS);
    }

    public void taskStarted(TaskEvent event) {
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2) {
            this.isolatedTasks.offer((IsolatedTask)event.attachement());
        }
    }

    private Object loadInstance(String property) {
        Class<?> className = null;
        Object pipeline = null;
        try {
            className = Class.forName(property);
            return className.newInstance();
        }
        catch (ClassNotFoundException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException ex) {
            // empty catch block
        }
        if (property.equals(ALGORITHM_CLASS)) {
            return new ContextRootAlgorithm();
        }
        if (property.equals(RULE_EXECUTOR_CLASS)) {
            return new IsolationRulesExecutor();
        }
        throw new IllegalStateException();
    }
}

