/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.config.ApplicationSecurityConfiguration;
import com.sun.xml.wss.impl.config.DeclarativeSecurityConfiguration;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.configuration.StaticApplicationContext;
import com.sun.xml.wss.impl.filter.AuthenticationTokenFilter;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.filter.EncryptionFilter;
import com.sun.xml.wss.impl.filter.SignatureConfirmationFilter;
import com.sun.xml.wss.impl.filter.SignatureFilter;
import com.sun.xml.wss.impl.filter.TimestampFilter;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DynamicSecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityRecipient {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validateMessage(ProcessingContext context) throws XWSSecurityException {
        FilterProcessingContext fpContext;
        block15: {
            block16: {
                SecurityPolicy policy;
                block17: {
                    HarnessUtil.validateContext(context);
                    policy = context.getSecurityPolicy();
                    StaticPolicyContext staticContext = context.getPolicyContext();
                    fpContext = new FilterProcessingContext(context);
                    fpContext.isInboundMessage(true);
                    fpContext.setExtraneousProperty("EnableWSS11PolicyReceiver", "true");
                    ArrayList scList = new ArrayList();
                    fpContext.setExtraneousProperty("receivedSignValues", scList);
                    if (policy == null) break block16;
                    if (PolicyTypeUtil.messagePolicy(policy) && !PolicyTypeUtil.applicationSecurityConfiguration(policy) && ((MessagePolicy)policy).enableDynamicPolicy() && ((MessagePolicy)policy).size() == 0) {
                        policy = new DynamicSecurityPolicy();
                    }
                    if (!PolicyTypeUtil.dynamicSecurityPolicy(policy)) break block17;
                    DynamicApplicationContext dynamicContext = new DynamicApplicationContext(staticContext);
                    dynamicContext.setMessageIdentifier(context.getMessageIdentifier());
                    dynamicContext.inBoundMessage(true);
                    ProcessingContext.copy(dynamicContext.getRuntimeProperties(), context.getExtraneousProperties());
                    DynamicPolicyCallback dpCallback = new DynamicPolicyCallback(policy, dynamicContext);
                    HarnessUtil.makeDynamicPolicyCallback(dpCallback, context.getSecurityEnvironment().getCallbackHandler());
                    SecurityPolicy result = dpCallback.getSecurityPolicy();
                    fpContext.setSecurityPolicy(result);
                    fpContext.setMode(0);
                    if (PolicyTypeUtil.messagePolicy(result)) {
                        SecurityRecipient.processMessagePolicy(fpContext);
                        break block15;
                    } else if (result instanceof WSSPolicy) {
                        HarnessUtil.processWSSPolicy(fpContext);
                        break block15;
                    } else if (result != null) {
                        log.log(Level.SEVERE, "WSS0260.invalid.DSP");
                        throw new XWSSecurityException("Invalid dynamic security policy returned by callback handler");
                    }
                    break block15;
                }
                if (policy instanceof WSSPolicy) {
                    fpContext.setMode(0);
                    HarnessUtil.processWSSPolicy(fpContext);
                    break block15;
                } else if (PolicyTypeUtil.messagePolicy(policy)) {
                    fpContext.enableDynamicPolicyCallback(((MessagePolicy)policy).enableDynamicPolicy());
                    fpContext.setMode(0);
                    SecurityRecipient.processMessagePolicy(fpContext);
                    SecurityRecipient.checkForExtraSecurity(fpContext);
                    break block15;
                } else {
                    if (!PolicyTypeUtil.applicationSecurityConfiguration(policy)) {
                        log.log(Level.SEVERE, "WSS0251.invalid.SecurityPolicyInstance");
                        throw new XWSSecurityException("SecurityPolicy instance should be of type: WSSPolicy OR MessagePolicy OR DynamicSecurityPolicy OR ApplicationSecurityConfiguration");
                    }
                    fpContext.setMode(1);
                    SecurityRecipient.processApplicationSecurityConfiguration(fpContext);
                    SecurityRecipient.checkForExtraSecurity(fpContext);
                }
                break block15;
            }
            SecurityRecipient.pProcess(fpContext);
        }
        try {
            if (!fpContext.retainSecurityHeader()) {
                fpContext.getSecurableSoapMessage().deleteSecurityHeader();
            } else {
                fpContext.getSecurableSoapMessage().resetMustUnderstandOnSecHeader();
            }
            fpContext.getSOAPMessage().saveChanges();
            return;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "WSS0370.error.deleting.secheader", ex);
            throw new XWSSecurityException(ex);
        }
    }

    private static void processApplicationSecurityConfiguration(FilterProcessingContext fpContext) throws XWSSecurityException {
        ApplicationSecurityConfiguration configuration = (ApplicationSecurityConfiguration)fpContext.getSecurityPolicy();
        Collection mConfiguration = configuration.getAllReceiverPolicies();
        fpContext.setSecurityPolicy(new MessagePolicy());
        SOAPElement current = fpContext.getSecurableSoapMessage().findSecurityHeader().getFirstChildElement();
        MessagePolicy policy = null;
        while (current != null) {
            fpContext.getSecurableSoapMessage().findSecurityHeader().setCurrentHeaderElement(current);
            SecurityRecipient.pProcessOnce(fpContext, current, false);
            if (!mConfiguration.isEmpty()) {
                try {
                    MessagePolicy mp = (MessagePolicy)fpContext.getSecurityPolicy();
                    if (!mp.isEmpty()) {
                        SecurityRecipient.redux(mp, mConfiguration, fpContext.getSecurableSoapMessage(), false);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS0256.failed.configure.ASC", e);
                    throw new XWSSecurityException(e);
                }
            }
            if ((policy = SecurityRecipient.resolveMP(fpContext, configuration)) != null) {
                if (!mConfiguration.contains(policy)) {
                    StringBuffer buf = null;
                    if (PolicyTypeUtil.messagePolicy(policy)) {
                        for (int it = 0; it < policy.size(); ++it) {
                            if (buf == null) {
                                buf = new StringBuffer();
                            }
                            try {
                                buf.append(policy.get(it).getType() + " ");
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        log.log(Level.SEVERE, "WSS0261.invalid.Message.policyset");
                        throw new XWSSecurityException("Message does not conform to configured policy : [ " + buf.toString() + "] policy set is not present in Receiver requirements.");
                    }
                    log.log(Level.SEVERE, "WSS0262.invalid.Message.policytype");
                    throw new XWSSecurityException("Message does not conform to configured policy : " + policy.getType() + " is not present in Receiver requirements.");
                }
                MessagePolicy policyCopy = new MessagePolicy();
                int size = ((MessagePolicy)fpContext.getSecurityPolicy()).size();
                int ppCount = 0;
                for (int i = 0; i < policy.size(); ++i) {
                    try {
                        WSSPolicy wp = (WSSPolicy)policy.get(i);
                        if (PolicyTypeUtil.isSecondaryPolicy(wp)) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, wp.getType());
                            }
                            policyCopy.append(wp);
                            continue;
                        }
                        if (ppCount >= size) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.log(Level.FINEST, wp.getType());
                            }
                            policyCopy.append(wp);
                        } else if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "skipped" + wp.getType());
                        }
                        ++ppCount;
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "WSS0257.failedto.append.SecurityPolicy.MessagePolicy", e);
                        throw new XWSSecurityException(e);
                    }
                }
                fpContext.setMode(0);
                fpContext.setSecurityPolicy(policyCopy);
                current = HarnessUtil.getNextElement(current);
                if (policy.dumpMessages()) {
                    DumpFilter.process(fpContext);
                }
                SecurityRecipient.processMessagePolicy(fpContext, current);
                break;
            }
            current = HarnessUtil.getNextElement(current);
        }
        SecurityRecipient.checkPolicyEquivalence(policy, mConfiguration);
    }

    private static MessagePolicy resolveMP(FilterProcessingContext fpContext, ApplicationSecurityConfiguration configuration) throws XWSSecurityException {
        String identifier = HarnessUtil.resolvePolicyIdentifier(fpContext.getSOAPMessage());
        if (identifier == null) {
            return null;
        }
        StaticPolicyContext context = fpContext.getPolicyContext();
        ((StaticApplicationContext)context).setOperationIdentifier(identifier);
        SecurityPolicy policy = configuration.getSecurityConfiguration((StaticApplicationContext)context);
        MessagePolicy mPolicy = null;
        if (PolicyTypeUtil.dynamicSecurityPolicy(policy)) {
            DynamicApplicationContext dynamicContext = new DynamicApplicationContext(context);
            dynamicContext.setMessageIdentifier(fpContext.getMessageIdentifier());
            dynamicContext.inBoundMessage(true);
            ProcessingContext.copy(dynamicContext.getRuntimeProperties(), fpContext.getExtraneousProperties());
            DynamicPolicyCallback dpCallback = new DynamicPolicyCallback(policy, dynamicContext);
            HarnessUtil.makeDynamicPolicyCallback(dpCallback, fpContext.getSecurityEnvironment().getCallbackHandler());
            if (!PolicyTypeUtil.messagePolicy(dpCallback.getSecurityPolicy())) {
                log.log(Level.SEVERE, "WSS0271.failedto.resolve.policy");
                throw new XWSSecurityException("Policy has to resolve to MessagePolicy");
            }
            mPolicy = (MessagePolicy)dpCallback.getSecurityPolicy();
        } else if (PolicyTypeUtil.declarativeSecurityConfiguration(policy)) {
            DeclarativeSecurityConfiguration dsc = (DeclarativeSecurityConfiguration)policy;
            mPolicy = dsc.receiverSettings();
        }
        return mPolicy;
    }

    private static void redux(MessagePolicy mPolicy, Collection configuration, SecurableSoapMessage message, boolean isSecondary) throws Exception {
        WSSPolicy policy = null;
        int _spSize = mPolicy.getSecondaryPolicies().size() - 1;
        if (isSecondary && _spSize >= 0) {
            policy = (WSSPolicy)mPolicy.getSecondaryPolicies().get(_spSize);
        } else {
            int _pSize = mPolicy.getPrimaryPolicies().size() - 1;
            if (_pSize >= 0) {
                policy = (WSSPolicy)mPolicy.getPrimaryPolicies().get(_pSize);
            }
        }
        if (policy == null) {
            return;
        }
        ArrayList<MessagePolicy> reduxx = new ArrayList<MessagePolicy>();
        Iterator i = configuration.iterator();
        while (i.hasNext()) {
            try {
                MessagePolicy policyx = (MessagePolicy)i.next();
                int spSize = mPolicy.getSecondaryPolicies().size() - 1;
                ArrayList policyxList = policyx.getPrimaryPolicies();
                WSSPolicy wssPolicyx = null;
                if (isSecondary && spSize >= 0) {
                    wssPolicyx = (WSSPolicy)policyx.get(spSize);
                } else {
                    int pSize = mPolicy.getPrimaryPolicies().size() - 1;
                    if (pSize < 0 || pSize >= policyxList.size()) continue;
                    wssPolicyx = (WSSPolicy)policyxList.get(pSize);
                }
                if (wssPolicyx == null || policy.equalsIgnoreTargets(wssPolicyx)) continue;
                reduxx.add(policyx);
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
        }
        Iterator j = configuration.iterator();
        while (j.hasNext()) {
            try {
                int spSize = mPolicy.getSecondaryPolicies().size() - 1;
                MessagePolicy policyy = (MessagePolicy)j.next();
                ArrayList policyyList = policyy.getPrimaryPolicies();
                WSSPolicy wssPolicyy = null;
                if (isSecondary && spSize >= 0) {
                    wssPolicyy = (WSSPolicy)policyy.get(spSize);
                } else {
                    int pSize = mPolicy.getPrimaryPolicies().size() - 1;
                    if (pSize < 0 || pSize >= policyyList.size()) continue;
                    wssPolicyy = (WSSPolicy)policyyList.get(pSize);
                }
                if (wssPolicyy == null || SecurityRecipient.checkTargetBasedRequirements(policy, wssPolicyy, message)) continue;
                reduxx.add(policyy);
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
        }
        configuration.removeAll(reduxx);
    }

    private static boolean checkTargetBasedRequirements(WSSPolicy inferred, WSSPolicy configured, SecurableSoapMessage message) {
        Object inferredTargets = null;
        Object configuredTargets = null;
        if (PolicyTypeUtil.encryptionPolicy(configured) && !PolicyTypeUtil.encryptionPolicy(inferred)) {
            return false;
        }
        if (PolicyTypeUtil.signaturePolicy(configured) && !PolicyTypeUtil.signaturePolicy(inferred)) {
            return false;
        }
        if (PolicyTypeUtil.signaturePolicy(inferred) && PolicyTypeUtil.signaturePolicy(configured)) {
            return SecurityRecipient.verifySignatureTargets(inferred, configured, message);
        }
        if (PolicyTypeUtil.encryptionPolicy(inferred) && PolicyTypeUtil.encryptionPolicy(configured)) {
            return SecurityRecipient.verifyEncryptionTargets(inferred, configured, message);
        }
        return false;
    }

    static boolean verifySignatureTargets(WSSPolicy inferred, WSSPolicy configured, SecurableSoapMessage message) {
        ArrayList inferredTargets = null;
        ArrayList configuredTargets = null;
        inferredTargets = ((SignaturePolicy.FeatureBinding)inferred.getFeatureBinding()).getTargetBindings();
        configuredTargets = ((SignaturePolicy.FeatureBinding)configured.getFeatureBinding()).getTargetBindings();
        ArrayList inferredNodeSet = new ArrayList();
        ArrayList configuredNodeSet = new ArrayList();
        try {
            SecurityRecipient.dereferenceTargets(inferredTargets, inferredNodeSet, message, false);
            SecurityRecipient.dereferenceTargets(configuredTargets, configuredNodeSet, message, false);
        }
        catch (XWSSecurityException xwsse) {
            return false;
        }
        if (inferredNodeSet.size() != configuredNodeSet.size()) {
            return false;
        }
        block2: for (int i = 0; i < configuredNodeSet.size(); ++i) {
            EncryptedData cn = (EncryptedData)configuredNodeSet.get(i);
            for (int j = 0; j < inferredNodeSet.size(); ++j) {
                EncryptedData ci = (EncryptedData)inferredNodeSet.get(j);
                boolean found = false;
                if (cn.isAttachmentData() && ci.isAttachmentData()) {
                    found = cn.equals((AttachmentData)ci);
                } else if (cn.isElementData() && ci.isElementData()) {
                    found = ((EncryptedElement)cn).equals((EncryptedElement)ci);
                }
                if (!found) continue;
                inferredNodeSet.remove(j);
                continue block2;
            }
        }
        return inferredNodeSet.size() == 0;
    }

    static boolean verifyEncryptionTargets(WSSPolicy inferred, WSSPolicy configured, SecurableSoapMessage message) {
        ArrayList inferredTargets = null;
        ArrayList configuredTargets = null;
        inferredTargets = ((EncryptionPolicy.FeatureBinding)inferred.getFeatureBinding()).getTargetBindings();
        configuredTargets = ((EncryptionPolicy.FeatureBinding)configured.getFeatureBinding()).getTargetBindings();
        ArrayList inferredNodeSet = new ArrayList();
        ArrayList configuredNodeSet = new ArrayList();
        try {
            SecurityRecipient.dereferenceTargets(inferredTargets, inferredNodeSet, message, true);
            SecurityRecipient.dereferenceTargets(configuredTargets, configuredNodeSet, message, false);
        }
        catch (XWSSecurityException xwsse) {
            return false;
        }
        if (inferredNodeSet.size() != configuredNodeSet.size()) {
            return false;
        }
        block2: for (int i = 0; i < configuredNodeSet.size(); ++i) {
            EncryptedData cn = (EncryptedData)configuredNodeSet.get(i);
            for (int j = 0; j < inferredNodeSet.size(); ++j) {
                EncryptedData ci = (EncryptedData)inferredNodeSet.get(j);
                boolean found = false;
                if (cn.isAttachmentData() && ci.isAttachmentData()) {
                    found = cn.equals((AttachmentData)ci);
                } else if (cn.isElementData() && ci.isElementData()) {
                    found = ((EncryptedElement)cn).equals((EncryptedElement)ci);
                }
                if (!found) continue;
                inferredNodeSet.remove(j);
                continue block2;
            }
        }
        return inferredNodeSet.size() == 0;
    }

    private static void dereferenceTargets(ArrayList targets, ArrayList nodeSet, SecurableSoapMessage message, boolean inferred) throws XWSSecurityException {
        for (Target t : targets) {
            boolean mandatory = t.getEnforce();
            boolean contentOnly = t.getContentOnly();
            Object object = null;
            EncryptedData data = null;
            try {
                if (!t.isAttachment()) {
                    Element el = null;
                    if (inferred && t instanceof EncryptionTarget) {
                        el = ((EncryptionTarget)t).getElementData();
                        data = new EncryptedElement(el, contentOnly);
                        nodeSet.add(data);
                        continue;
                    }
                    object = message.getMessageParts(t);
                    if (object instanceof Element) {
                        data = new EncryptedElement((Element)object, contentOnly);
                        nodeSet.add(data);
                        continue;
                    }
                    if (object instanceof NodeList) {
                        NodeList nl = (NodeList)object;
                        for (int j = 0; j < nl.getLength(); ++j) {
                            data = new EncryptedElement((Element)nl.item(j), contentOnly);
                            nodeSet.add(data);
                        }
                        continue;
                    }
                    if (!(object instanceof Node)) continue;
                    data = new EncryptedElement((Element)object, contentOnly);
                    nodeSet.add(data);
                    continue;
                }
                if (!inferred) {
                    AttachmentPart ap = (AttachmentPart)message.getMessageParts(t);
                    data = new AttachmentData(ap.getContentId(), contentOnly);
                } else {
                    data = new AttachmentData(t.getValue(), contentOnly);
                }
                nodeSet.add(data);
            }
            catch (XWSSecurityException ex) {
                if (inferred || !mandatory) continue;
                log.log(Level.SEVERE, "WSS0272.failedto.derefer.targets");
                throw ex;
            }
        }
    }

    private static void checkPolicyEquivalence(MessagePolicy policy, Collection configuration) throws XWSSecurityException {
        if (policy != null) {
            for (MessagePolicy mPolicy : configuration) {
                if (policy != mPolicy) continue;
                return;
            }
            log.log(Level.SEVERE, "WSS0263.invalid.Message.policy");
            throw new XWSSecurityException("Message does not conform to configured policy");
        }
    }

    private static void processMessagePolicy(FilterProcessingContext fpContext) throws XWSSecurityException {
        MessagePolicy policy = (MessagePolicy)fpContext.getSecurityPolicy();
        if (policy.dumpMessages()) {
            DumpFilter.process(fpContext);
        }
        if (policy.size() == 0) {
            fpContext.setMode(2);
            SecurityRecipient.pProcess(fpContext);
            return;
        }
        try {
            if (policy.size() == 1 && PolicyTypeUtil.signatureConfirmationPolicy(policy.get(0))) {
                fpContext.setMode(2);
                SecurityRecipient.pProcess(fpContext);
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0273.failedto.process.policy", e);
            throw new RuntimeException(e);
        }
        SecurityHeader header = fpContext.getSecurableSoapMessage().findSecurityHeader();
        if (header == null) {
            StringBuffer buf = new StringBuffer();
            for (int it = 0; it < policy.size(); ++it) {
                try {
                    buf.append(policy.get(it).getType());
                    if (PolicyTypeUtil.isPrimaryPolicy((WSSPolicy)policy.get(it))) {
                        buf.append("(P) ");
                        continue;
                    }
                    buf.append("(S) ");
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            log.log(Level.SEVERE, "WSS0253.invalid.Message");
            throw new XWSSecurityException("Message does not conform to configured policy [ " + buf.toString() + "]:  No Security Header found");
        }
        SOAPElement current = header.getFirstChildElement();
        SecurityRecipient.processMessagePolicy(fpContext, current);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processMessagePolicy(FilterProcessingContext fpContext, SOAPElement current) throws XWSSecurityException {
        int unpCount;
        NodeList uList;
        MessagePolicy policy;
        block35: {
            int tspCount;
            NodeList tList;
            int idx = 0;
            policy = (MessagePolicy)fpContext.getSecurityPolicy();
            SecurableSoapMessage secureMsg = fpContext.getSecurableSoapMessage();
            MessagePolicy secPolicy = null;
            ArrayList targets = null;
            StringBuffer buf = null;
            boolean foundPrimaryPolicy = false;
            while (true) {
                block40: {
                    Iterator ite;
                    WSSPolicy wssPolicy;
                    block39: {
                        SecurityHeader securityHeader;
                        block37: {
                            block38: {
                                if (idx >= policy.size()) break block37;
                                wssPolicy = null;
                                try {
                                    wssPolicy = (WSSPolicy)policy.get(idx);
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, "WSS0270.failedto.get.SecurityPolicy.MessagePolicy");
                                    throw new XWSSecurityException(e);
                                }
                                if (!PolicyTypeUtil.isPrimaryPolicy(wssPolicy)) break block38;
                                targets = wssPolicy.getType().equals("EncryptionPolicy") ? ((EncryptionPolicy.FeatureBinding)wssPolicy.getFeatureBinding()).getTargetBindings() : ((SignaturePolicy.FeatureBinding)wssPolicy.getFeatureBinding()).getTargetBindings();
                                foundPrimaryPolicy = true;
                                ite = targets.iterator();
                                break block39;
                            }
                            if (secPolicy == null) {
                                secPolicy = new MessagePolicy();
                            }
                            secPolicy.append(wssPolicy);
                            break block40;
                        }
                        if (buf != null) {
                            log.log(Level.SEVERE, "WSS0258.invalid.requirements");
                            throw new XWSSecurityException("More Receiver requirements [ " + buf + " ] specified" + " than present in the message");
                        }
                        if (!foundPrimaryPolicy) {
                            SecurityHeader header = secureMsg.findSecurityHeader();
                            if (header != null && header.getCurrentHeaderElement() == null) {
                                header.setCurrentHeaderElement(header.getFirstChildElement());
                            }
                            SecurityRecipient.checkForExtraSecurity(fpContext);
                        }
                        if ((uList = (securityHeader = secureMsg.findSecurityHeader()).getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken")).getLength() > 1) {
                            log.log(Level.SEVERE, "WSS0259.invalid.SEC.username");
                            throw new XWSSecurityException("More than one wsse:UsernameToken element present in security header");
                        }
                        tList = securityHeader.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
                        if (tList.getLength() > 1) {
                            log.log(Level.SEVERE, "WSS0274.invalid.SEC.Timestamp");
                            throw new XWSSecurityException("More than one wsu:Timestamp element present in security header");
                        }
                        unpCount = 0;
                        tspCount = 0;
                        if (secPolicy != null) {
                            break;
                        }
                        break block35;
                    }
                    while (ite.hasNext()) {
                        boolean keepCurrent;
                        Target t = (Target)ite.next();
                        if (t.getEnforce()) {
                            while (current != null && HarnessUtil.isSecondaryHeaderElement(current)) {
                                current = HarnessUtil.getNextElement(current);
                            }
                            if (current != null) {
                                secureMsg.findSecurityHeader().setCurrentHeaderElement(current);
                                fpContext.setSecurityPolicy(wssPolicy);
                                HarnessUtil.processDeep(fpContext);
                                keepCurrent = false;
                                if ("EncryptedData".equals(current.getLocalName())) {
                                    keepCurrent = true;
                                }
                                if (fpContext.isPrimaryPolicyViolation()) {
                                    log.log(Level.SEVERE, "WSS0265.error.primary.policy");
                                    throw new XWSSecurityException(fpContext.getPVE());
                                }
                                if (fpContext.isOptionalPolicyViolation()) {
                                    secureMsg.findSecurityHeader().setCurrentHeaderElement(current);
                                }
                                if (!keepCurrent) {
                                    current = secureMsg.findSecurityHeader().getCurrentHeaderBlockElement();
                                    break;
                                }
                                current = HarnessUtil.getNextElement(secureMsg.findSecurityHeader().getCurrentHeaderBlockElement());
                                break;
                            }
                            if (buf == null) {
                                buf = new StringBuffer();
                            }
                            buf.append(wssPolicy.getType() + " ");
                            continue;
                        }
                        while (current != null && HarnessUtil.isSecondaryHeaderElement(current)) {
                            current = HarnessUtil.getNextElement(current);
                        }
                        if (current != null && wssPolicy.getType().equals("EncryptionPolicy") && current.getLocalName().equals("Signature") || current != null && wssPolicy.getType().equals("SignaturePolicy") && (current.getLocalName().equals("EncryptedData") || current.getLocalName().equals("EncryptedKey") || current.getLocalName().equals("ReferenceList")) || current == null) continue;
                        secureMsg.findSecurityHeader().setCurrentHeaderElement(current);
                        fpContext.setSecurityPolicy(wssPolicy);
                        HarnessUtil.processDeep(fpContext);
                        keepCurrent = false;
                        if ("EncryptedData".equals(current.getLocalName())) {
                            keepCurrent = true;
                        }
                        if (fpContext.isPrimaryPolicyViolation()) {
                            log.log(Level.SEVERE, "WSS0265.error.primary.policy");
                            throw new XWSSecurityException(fpContext.getPVE());
                        }
                        if (fpContext.isOptionalPolicyViolation()) {
                            secureMsg.findSecurityHeader().setCurrentHeaderElement(current);
                        }
                        current = !keepCurrent ? secureMsg.findSecurityHeader().getCurrentHeaderBlockElement() : HarnessUtil.getNextElement(secureMsg.findSecurityHeader().getCurrentHeaderBlockElement());
                        break;
                    }
                }
                ++idx;
            }
            for (idx = 0; idx < secPolicy.size(); ++idx) {
                WSSPolicy wssPolicy = null;
                try {
                    wssPolicy = (WSSPolicy)secPolicy.get(idx);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS0270.failedto.get.SecurityPolicy.MessagePolicy");
                    throw new XWSSecurityException(e);
                }
                if (PolicyTypeUtil.authenticationTokenPolicy(wssPolicy)) {
                    AuthenticationTokenPolicy atp = (AuthenticationTokenPolicy)wssPolicy;
                    WSSPolicy fb = (WSSPolicy)atp.getFeatureBinding();
                    if (PolicyTypeUtil.usernameTokenPolicy(fb)) {
                        if (uList.getLength() == 0) {
                            log.log(Level.SEVERE, "WSS0275.invalid.policy.NoUsername.SecHeader");
                            throw new XWSSecurityException("Message does not conform to configured policy: wsse:UsernameToken element not found in security header");
                        }
                        ++unpCount;
                    } else if (!PolicyTypeUtil.samlTokenPolicy(fb)) {
                        // empty if block
                    }
                } else if (PolicyTypeUtil.timestampPolicy(wssPolicy)) {
                    if (tList.getLength() == 0) {
                        log.log(Level.SEVERE, "WSS0276.invalid.policy.NoTimestamp.SecHeader");
                        throw new XWSSecurityException("Message does not conform to configured policy: wsu:Timestamp element not found in security header");
                    }
                    ++tspCount;
                }
                fpContext.setSecurityPolicy(wssPolicy);
                HarnessUtil.processDeep(fpContext);
            }
        }
        if (uList.getLength() > unpCount) {
            log.log(Level.SEVERE, "WSS0259.invalid.SEC.username");
            throw new XWSSecurityException("Message does not conform to configured policy: Additional wsse:UsernameToken element found in security header");
        }
        fpContext.setSecurityPolicy(policy);
    }

    private static void checkForExtraSecurity(FilterProcessingContext context) throws XWSSecurityException {
        SecurityHeader header = context.getSecurableSoapMessage().findSecurityHeader();
        if (header == null || header.getCurrentHeaderElement() == null) {
            return;
        }
        for (Node nextNode = header.getCurrentHeaderElement().getNextSibling(); nextNode != null; nextNode = nextNode.getNextSibling()) {
            SOAPElement current;
            if (!(nextNode instanceof SOAPElement) || HarnessUtil.isSecondaryHeaderElement(current = (SOAPElement)nextNode)) continue;
            log.log(Level.SEVERE, "WSS0277.invalid.AddtionalSEC.Message.policy");
            throw new XWSSecurityException("Message does not conform to configured policy (found " + current.getLocalName() + ") : " + "Additional security than required found");
        }
    }

    private static void checkForExtraSecondarySecurity(FilterProcessingContext context) throws XWSSecurityException {
        SecurityHeader header = context.getSecurableSoapMessage().findSecurityHeader();
        MessagePolicy policy = (MessagePolicy)context.getSecurityPolicy();
        boolean _UT = false;
        boolean _TS = false;
        for (SOAPElement current = header.getFirstChildElement(); current != null; current = (SOAPElement)current.getNextSibling()) {
            try {
                _UT = current.getLocalName().equals("UsernameToken");
                _TS = current.getLocalName().equals("Timestamp");
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0278.failedto.get.localName");
                throw new XWSSecurityRuntimeException(e);
            }
        }
        boolean throwFault = false;
        StringBuffer buf = null;
        if (!_UT) {
            for (int i = 0; i < policy.size(); ++i) {
                try {
                    if (!PolicyTypeUtil.usernameTokenPolicy(policy.get(i))) continue;
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(policy.get(i).getType() + " ");
                    throwFault = true;
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS0279.failed.check.secSecurity", e);
                    throw new XWSSecurityRuntimeException(e);
                }
            }
        }
        if (!_TS) {
            for (int j = 0; j < policy.size(); ++j) {
                try {
                    if (!PolicyTypeUtil.timestampPolicy(policy.get(j))) continue;
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(policy.get(j).getType() + " ");
                    throwFault = true;
                    continue;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "WSS0279.failed.check.secSecurity", e);
                    throw new XWSSecurityRuntimeException(e);
                }
            }
        }
        if (throwFault) {
            log.log(Level.SEVERE, "WSS0277.invalid.AddtionalSEC.Message.policy");
        }
        throw new XWSSecurityException("Message does not conform to configured policy: Additional security [ " + buf.toString() + "] than required found");
    }

    private static boolean pProcessOnce(FilterProcessingContext fpContext, SOAPElement current, boolean isSecondary) throws XWSSecurityException {
        boolean processed = false;
        String elementName = current.getLocalName();
        if (isSecondary) {
            if ("UsernameToken".equals(elementName)) {
                AuthenticationTokenFilter.processUserNameToken(fpContext);
                processed = true;
            } else if ("Timestamp".equals(elementName)) {
                TimestampFilter.process(fpContext);
                processed = true;
            } else if ("SignatureConfirmation".equals(elementName)) {
                SignatureConfirmationFilter.process(fpContext);
                processed = true;
            } else if (!"BinarySecurityToken".equals(elementName)) {
                if ("Assertion".equals(elementName)) {
                    AuthenticationTokenFilter.processSamlToken(fpContext);
                } else if (!"SecurityTokenReference".equals(elementName) && "SecurityContextToken".equals(elementName)) {
                    // empty if block
                }
            }
        } else if ("Signature".equals(elementName)) {
            SignatureFilter.process(fpContext);
            processed = true;
        } else if ("EncryptedKey".equals(elementName)) {
            Iterator iter = null;
            try {
                iter = current.getChildElements(SOAPFactory.newInstance().createName("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "WSS0360.error.creating.rlhb", e);
                throw new XWSSecurityException(e);
            }
            if (iter.hasNext()) {
                EncryptionFilter.process(fpContext);
                processed = true;
            }
        } else if ("ReferenceList".equals(elementName)) {
            EncryptionFilter.process(fpContext);
            processed = true;
        } else if ("EncryptedData".equals(elementName)) {
            EncryptionFilter.process(fpContext);
            processed = true;
        } else if (!HarnessUtil.isSecondaryHeaderElement(current)) {
            log.log(Level.SEVERE, "WSS0204.illegal.header.block", elementName);
            HarnessUtil.throwWssSoapFault("Unrecognized header block: " + elementName);
        }
        return processed;
    }

    private static void pProcess(FilterProcessingContext fpContext) throws XWSSecurityException {
        SOAPElement current;
        SecurityHeader header = fpContext.getSecurableSoapMessage().findSecurityHeader();
        if (header == null) {
            SecurityPolicy policy = fpContext.getSecurityPolicy();
            if (policy != null) {
                if (PolicyTypeUtil.messagePolicy(policy)) {
                    if (!((MessagePolicy)policy).isEmpty()) {
                        log.log(Level.SEVERE, "WSS0253.invalid.Message");
                        throw new XWSSecurityException("Message does not conform to configured policy: No Security Header found in incoming message");
                    }
                } else {
                    log.log(Level.SEVERE, "WSS0253.invalid.Message");
                    throw new XWSSecurityException("Message does not conform to configured policy: No Security Header found in incoming message");
                }
            }
            return;
        }
        SOAPElement first = current = header.getCurrentHeaderBlockElement();
        SOAPElement prev = null;
        while (current != null) {
            SecurityRecipient.pProcessOnce(fpContext, current, false);
            if (fpContext.getMode() == 2 && "EncryptedData".equals(current.getLocalName()) && prev != null) {
                header.setCurrentHeaderElement(prev);
            } else {
                prev = current;
            }
            current = header.getCurrentHeaderBlockElement();
        }
        current = first;
        header.setCurrentHeaderElement(current);
        while (current != null) {
            SecurityRecipient.pProcessOnce(fpContext, current, true);
            current = header.getCurrentHeaderBlockElement();
        }
    }

    public static void handleFault(ProcessingContext context) {
    }

    private static class EncryptedElement
    implements EncryptedData {
        private Element element;
        private boolean contentOnly;
        private EncryptionPolicy policy = null;

        public EncryptedElement(Element element, boolean contentOnly) {
            this.element = element;
            this.contentOnly = contentOnly;
        }

        public Element getElement() {
            return this.element;
        }

        public boolean getContentOnly() {
            return this.contentOnly;
        }

        public boolean equals(EncryptedElement element) {
            EncryptedElement encryptedElement = element;
            return encryptedElement.getElement() == this.element && encryptedElement.getContentOnly() == this.contentOnly;
        }

        public void setpolicy(EncryptionPolicy policy) {
            this.policy = policy;
        }

        public EncryptionPolicy getPolicy() {
            return this.policy;
        }

        public boolean isElementData() {
            return true;
        }

        public boolean isAttachmentData() {
            return false;
        }
    }

    private static class AttachmentData
    implements EncryptedData {
        private String cid = null;
        private boolean contentOnly = false;

        public AttachmentData(String cid, boolean co) {
            this.cid = cid;
            this.contentOnly = co;
        }

        public String getCID() {
            return this.cid;
        }

        public boolean isContentOnly() {
            return this.contentOnly;
        }

        public boolean equals(AttachmentData data) {
            return this.cid != null && this.cid.equals(data.getCID()) && this.contentOnly == data.isContentOnly();
        }

        public boolean isElementData() {
            return false;
        }

        public boolean isAttachmentData() {
            return true;
        }
    }

    private static interface EncryptedData {
        public boolean isElementData();

        public boolean isAttachmentData();
    }
}

